<?php

namespace MailPoetGenerated;

if (!defined('ABSPATH')) exit;


use MailPoetVendor\Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use MailPoetVendor\Symfony\Component\DependencyInjection\ContainerInterface;
use MailPoetVendor\Symfony\Component\DependencyInjection\Container;
use MailPoetVendor\Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use MailPoetVendor\Symfony\Component\DependencyInjection\Exception\LogicException;
use MailPoetVendor\Symfony\Component\DependencyInjection\Exception\RuntimeException;
use MailPoetVendor\Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use MailPoetVendor\Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class PremiumCachedContainer extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'free_container' => true,
        ];
        $this->methodMap = [
            'MailPoetVendor\\Doctrine\\ORM\\EntityManager' => 'getEntityManagerService',
            'MailPoet\\Automation\\Engine\\Builder\\UpdateAutomationController' => 'getUpdateAutomationControllerService',
            'MailPoet\\Automation\\Engine\\Builder\\UpdateStepsController' => 'getUpdateStepsControllerService',
            'MailPoet\\Automation\\Engine\\Control\\ActionScheduler' => 'getActionSchedulerService',
            'MailPoet\\Automation\\Engine\\Control\\FilterHandler' => 'getFilterHandlerService',
            'MailPoet\\Automation\\Engine\\Hooks' => 'getHooksService',
            'MailPoet\\Automation\\Engine\\Mappers\\AutomationMapper' => 'getAutomationMapperService',
            'MailPoet\\Automation\\Engine\\Registry' => 'getRegistryService',
            'MailPoet\\Automation\\Engine\\Storage\\AutomationRunLogStorage' => 'getAutomationRunLogStorageService',
            'MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage' => 'getAutomationRunStorageService',
            'MailPoet\\Automation\\Engine\\Storage\\AutomationStatisticsStorage' => 'getAutomationStatisticsStorageService',
            'MailPoet\\Automation\\Engine\\Storage\\AutomationStorage' => 'getAutomationStorageService',
            'MailPoet\\Automation\\Engine\\Templates\\AutomationBuilder' => 'getAutomationBuilderService',
            'MailPoet\\Automation\\Engine\\Validation\\AutomationValidator' => 'getAutomationValidatorService',
            'MailPoet\\Automation\\Engine\\WordPress' => 'getWordPressService',
            'MailPoet\\Automation\\Integrations\\MailPoet\\Actions\\SendEmailAction' => 'getSendEmailActionService',
            'MailPoet\\Automation\\Integrations\\MailPoet\\Analytics\\Controller\\AutomationTimeSpanController' => 'getAutomationTimeSpanControllerService',
            'MailPoet\\Automation\\Integrations\\MailPoet\\Subjects\\SubscriberSubject' => 'getSubscriberSubjectService',
            'MailPoet\\Automation\\Integrations\\MailPoet\\Templates\\EmailFactory' => 'getEmailFactoryService',
            'MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce' => 'getWooCommerceService',
            'MailPoet\\Config\\AccessControl' => 'getAccessControlService',
            'MailPoet\\Config\\Renderer' => 'getRendererService',
            'MailPoet\\Cron\\Workers\\StatsNotifications\\NewsletterLinkRepository' => 'getNewsletterLinkRepositoryService',
            'MailPoet\\CustomFields\\CustomFieldsRepository' => 'getCustomFieldsRepositoryService',
            'MailPoet\\Features\\FeaturesController' => 'getFeaturesControllerService',
            'MailPoet\\Listing\\Handler' => 'getHandlerService',
            'MailPoet\\Listing\\PageLimit' => 'getPageLimitService',
            'MailPoet\\Mailer\\MailerFactory' => 'getMailerFactoryService',
            'MailPoet\\Newsletter\\NewsletterSaveController' => 'getNewsletterSaveControllerService',
            'MailPoet\\Newsletter\\NewslettersRepository' => 'getNewslettersRepositoryService',
            'MailPoet\\Newsletter\\Options\\NewsletterOptionFieldsRepository' => 'getNewsletterOptionFieldsRepositoryService',
            'MailPoet\\Newsletter\\Options\\NewsletterOptionsRepository' => 'getNewsletterOptionsRepositoryService',
            'MailPoet\\Newsletter\\Sending\\ScheduledTaskSubscribersRepository' => 'getScheduledTaskSubscribersRepositoryService',
            'MailPoet\\Newsletter\\Sending\\ScheduledTasksRepository' => 'getScheduledTasksRepositoryService',
            'MailPoet\\Newsletter\\Statistics\\NewsletterStatisticsRepository' => 'getNewsletterStatisticsRepositoryService',
            'MailPoet\\Newsletter\\Url' => 'getUrlService',
            'MailPoet\\Premium\\API\\JSON\\v1\\Bounces' => 'getBouncesService',
            'MailPoet\\Premium\\API\\JSON\\v1\\ResponseBuilders\\StatsResponseBuilder' => 'getStatsResponseBuilderService',
            'MailPoet\\Premium\\API\\JSON\\v1\\Stats' => 'getStatsService',
            'MailPoet\\Premium\\API\\JSON\\v1\\SubscriberDetailedStats' => 'getSubscriberDetailedStatsService',
            'MailPoet\\Premium\\Automation\\Engine\\Builder\\CreateAutomationController' => 'getCreateAutomationControllerService',
            'MailPoet\\Premium\\Automation\\Engine\\Builder\\UpdateAutomationController' => 'getUpdateAutomationController2Service',
            'MailPoet\\Premium\\Automation\\Engine\\Endpoints\\Automations\\AutomationsPostEndpoint' => 'getAutomationsPostEndpointService',
            'MailPoet\\Premium\\Automation\\Engine\\Endpoints\\Automations\\AutomationsPutEndpoint' => 'getAutomationsPutEndpointService',
            'MailPoet\\Premium\\Automation\\Engine\\Engine' => 'getEngineService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddTagAction' => 'getAddTagActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddToListAction' => 'getAddToListActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\CustomAction' => 'getCustomActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\NotificationEmailAction' => 'getNotificationEmailActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveFromListAction' => 'getRemoveFromListActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveTagAction' => 'getRemoveTagActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UnsubscribeAction' => 'getUnsubscribeActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UpdateSubscriberAction' => 'getUpdateSubscriberActionService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Analytics' => 'getAnalyticsService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\OrderController' => 'getOrderControllerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\RunLogController' => 'getRunLogControllerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\SubscriberController' => 'getSubscriberControllerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\OrderEndpoint' => 'getOrderEndpointService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\RunLogEndpoint' => 'getRunLogEndpointService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\SubscriberEndpoint' => 'getSubscriberEndpointService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\OrderStatistics' => 'getOrderStatisticsService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\SubscriberStatistics' => 'getSubscriberStatisticsService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\ContextFactory' => 'getContextFactoryService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\MailPoetPremiumIntegration' => 'getMailPoetPremiumIntegrationService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\CustomDataSubject' => 'getCustomDataSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\TagSubject' => 'getTagSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\UserRoleChangeSubject' => 'getUserRoleChangeSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumEmailFactory' => 'getPremiumEmailFactoryService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumTemplatesFactory' => 'getPremiumTemplatesFactoryService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\ClicksEmailLinkTrigger' => 'getClicksEmailLinkTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\CustomTrigger' => 'getCustomTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagAddedTrigger' => 'getTagAddedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagRemovedTrigger' => 'getTagRemovedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\UserRoleChangedTrigger' => 'getUserRoleChangedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\ContextFactory' => 'getContextFactory2Service',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Fields\\SubscriptionFields' => 'getSubscriptionFieldsService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionStatusChangeSubject' => 'getWooCommerceSubscriptionStatusChangeSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionSubject' => 'getWooCommerceSubscriptionSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionCreatedTrigger' => 'getSubscriptionCreatedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionExpiredTrigger' => 'getSubscriptionExpiredTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionPaymentFailedTrigger' => 'getSubscriptionPaymentFailedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionRenewedTrigger' => 'getSubscriptionRenewedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionStatusChangedTrigger' => 'getSubscriptionStatusChangedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialEndedTrigger' => 'getSubscriptionTrialEndedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialStartedTrigger' => 'getSubscriptionTrialStartedTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\WooCommerceSubscriptionsIntegration' => 'getWooCommerceSubscriptionsIntegrationService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Actions\\Extenders\\ReviewCrossSellHandler' => 'getReviewCrossSellHandlerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Subjects\\ReviewSubject' => 'getReviewSubjectService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Triggers\\MadeAReviewTrigger' => 'getMadeAReviewTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\WooCommerceIntegration' => 'getWooCommerceIntegrationService',
            'MailPoet\\Premium\\Automation\\Integrations\\WordPress\\Triggers\\MadeACommentTrigger' => 'getMadeACommentTriggerService',
            'MailPoet\\Premium\\Automation\\Integrations\\WordPress\\WordPressIntegration' => 'getWordPressIntegrationService',
            'MailPoet\\Premium\\Config\\Initializer' => 'getInitializerService',
            'MailPoet\\Premium\\Config\\Renderer' => 'getRenderer2Service',
            'MailPoet\\Premium\\Config\\RendererFactory' => 'getRendererFactoryService',
            'MailPoet\\Premium\\Newsletter\\StatisticsClicksRepository' => 'getStatisticsClicksRepositoryService',
            'MailPoet\\Premium\\Newsletter\\Stats\\Bounces' => 'getBounces2Service',
            'MailPoet\\Premium\\Newsletter\\Stats\\SubscriberEngagement' => 'getSubscriberEngagementService',
            'MailPoet\\Premium\\Segments\\DynamicSegments\\Filters\\SubscriberTag' => 'getSubscriberTagService',
            'MailPoet\\Premium\\Segments\\DynamicSegments\\SegmentCombinations' => 'getSegmentCombinationsService',
            'MailPoet\\Segments\\SegmentsRepository' => 'getSegmentsRepositoryService',
            'MailPoet\\Settings\\SettingsController' => 'getSettingsControllerService',
            'MailPoet\\Settings\\TrackingConfig' => 'getTrackingConfigService',
            'MailPoet\\Statistics\\StatisticsWooCommercePurchasesRepository' => 'getStatisticsWooCommercePurchasesRepositoryService',
            'MailPoet\\Statistics\\Track\\Unsubscribes' => 'getUnsubscribesService',
            'MailPoet\\Subscribers\\SubscriberCustomFieldRepository' => 'getSubscriberCustomFieldRepositoryService',
            'MailPoet\\Subscribers\\SubscriberSegmentRepository' => 'getSubscriberSegmentRepositoryService',
            'MailPoet\\Subscribers\\SubscriberTagRepository' => 'getSubscriberTagRepositoryService',
            'MailPoet\\Subscribers\\SubscribersRepository' => 'getSubscribersRepositoryService',
            'MailPoet\\Tags\\TagRepository' => 'getTagRepositoryService',
            'MailPoet\\Util\\CdnAssetUrl' => 'getCdnAssetUrlService',
            'MailPoet\\Util\\License\\Features\\Subscribers' => 'getSubscribersService',
            'MailPoet\\WP\\Functions' => 'getFunctionsService',
            'MailPoet\\WooCommerce\\Helper' => 'getHelperService',
            'MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper' => 'getHelper2Service',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            'MailPoetVendor\\Psr\\Container\\ContainerInterface' => true,
            'MailPoetVendor\\Symfony\\Component\\DependencyInjection\\ContainerInterface' => true,
            'MailPoet\\Premium\\API\\JSON\\v1\\ResponseBuilders\\SubscriberDetailedStatsResponseBuilder' => true,
            'MailPoet\\Premium\\Config\\Hooks' => true,
            'MailPoet\\Premium\\Newsletter\\StatisticsOpensRepository' => true,
            'MailPoet\\Premium\\Newsletter\\StatisticsUnsubscribesRepository' => true,
            'MailPoet\\Premium\\Newsletter\\Stats\\PurchasedProducts' => true,
            'MailPoet\\Premium\\Subscriber\\Stats\\SubscriberNewsletterStatsRepository' => true,
        ];
    }

    /**
     * Gets the public 'MailPoetVendor\Doctrine\ORM\EntityManager' shared service.
     *
     * @return \MailPoetVendor\Doctrine\ORM\EntityManager
     */
    protected function getEntityManagerService()
    {
        return $this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoetVendor\\Doctrine\\ORM\\EntityManager');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Builder\UpdateAutomationController' shared service.
     *
     * @return \MailPoet\Automation\Engine\Builder\UpdateAutomationController
     */
    protected function getUpdateAutomationControllerService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Builder\\UpdateAutomationController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Builder\\UpdateAutomationController');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Builder\UpdateStepsController' shared service.
     *
     * @return \MailPoet\Automation\Engine\Builder\UpdateStepsController
     */
    protected function getUpdateStepsControllerService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Builder\\UpdateStepsController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Builder\\UpdateStepsController');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Control\ActionScheduler' shared service.
     *
     * @return \MailPoet\Automation\Engine\Control\ActionScheduler
     */
    protected function getActionSchedulerService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Control\\ActionScheduler'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Control\\ActionScheduler');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Control\FilterHandler' shared service.
     *
     * @return \MailPoet\Automation\Engine\Control\FilterHandler
     */
    protected function getFilterHandlerService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Control\\FilterHandler'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Control\\FilterHandler');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Hooks' shared service.
     *
     * @return \MailPoet\Automation\Engine\Hooks
     */
    protected function getHooksService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Hooks'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Hooks');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Mappers\AutomationMapper' shared service.
     *
     * @return \MailPoet\Automation\Engine\Mappers\AutomationMapper
     */
    protected function getAutomationMapperService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Mappers\\AutomationMapper'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Mappers\\AutomationMapper');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Registry' shared service.
     *
     * @return \MailPoet\Automation\Engine\Registry
     */
    protected function getRegistryService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Registry'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Registry');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Storage\AutomationRunLogStorage' shared service.
     *
     * @return \MailPoet\Automation\Engine\Storage\AutomationRunLogStorage
     */
    protected function getAutomationRunLogStorageService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunLogStorage'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Storage\\AutomationRunLogStorage');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Storage\AutomationRunStorage' shared service.
     *
     * @return \MailPoet\Automation\Engine\Storage\AutomationRunStorage
     */
    protected function getAutomationRunStorageService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Storage\AutomationStatisticsStorage' shared service.
     *
     * @return \MailPoet\Automation\Engine\Storage\AutomationStatisticsStorage
     */
    protected function getAutomationStatisticsStorageService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStatisticsStorage'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Storage\\AutomationStatisticsStorage');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Storage\AutomationStorage' shared service.
     *
     * @return \MailPoet\Automation\Engine\Storage\AutomationStorage
     */
    protected function getAutomationStorageService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Storage\\AutomationStorage');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Templates\AutomationBuilder' shared service.
     *
     * @return \MailPoet\Automation\Engine\Templates\AutomationBuilder
     */
    protected function getAutomationBuilderService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Templates\\AutomationBuilder'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Templates\\AutomationBuilder');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\Validation\AutomationValidator' shared service.
     *
     * @return \MailPoet\Automation\Engine\Validation\AutomationValidator
     */
    protected function getAutomationValidatorService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\Validation\\AutomationValidator'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\Validation\\AutomationValidator');
    }

    /**
     * Gets the public 'MailPoet\Automation\Engine\WordPress' shared service.
     *
     * @return \MailPoet\Automation\Engine\WordPress
     */
    protected function getWordPressService()
    {
        return $this->services['MailPoet\\Automation\\Engine\\WordPress'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Engine\\WordPress');
    }

    /**
     * Gets the public 'MailPoet\Automation\Integrations\MailPoet\Actions\SendEmailAction' shared service.
     *
     * @return \MailPoet\Automation\Integrations\MailPoet\Actions\SendEmailAction
     */
    protected function getSendEmailActionService()
    {
        return $this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Actions\\SendEmailAction'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Integrations\\MailPoet\\Actions\\SendEmailAction');
    }

    /**
     * Gets the public 'MailPoet\Automation\Integrations\MailPoet\Analytics\Controller\AutomationTimeSpanController' shared service.
     *
     * @return \MailPoet\Automation\Integrations\MailPoet\Analytics\Controller\AutomationTimeSpanController
     */
    protected function getAutomationTimeSpanControllerService()
    {
        return $this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Analytics\\Controller\\AutomationTimeSpanController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Integrations\\MailPoet\\Analytics\\Controller\\AutomationTimeSpanController');
    }

    /**
     * Gets the public 'MailPoet\Automation\Integrations\MailPoet\Subjects\SubscriberSubject' shared service.
     *
     * @return \MailPoet\Automation\Integrations\MailPoet\Subjects\SubscriberSubject
     */
    protected function getSubscriberSubjectService()
    {
        return $this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Subjects\\SubscriberSubject'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Integrations\\MailPoet\\Subjects\\SubscriberSubject');
    }

    /**
     * Gets the public 'MailPoet\Automation\Integrations\MailPoet\Templates\EmailFactory' shared service.
     *
     * @return \MailPoet\Automation\Integrations\MailPoet\Templates\EmailFactory
     */
    protected function getEmailFactoryService()
    {
        return $this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Templates\\EmailFactory'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Integrations\\MailPoet\\Templates\\EmailFactory');
    }

    /**
     * Gets the public 'MailPoet\Automation\Integrations\WooCommerce\WooCommerce' shared service.
     *
     * @return \MailPoet\Automation\Integrations\WooCommerce\WooCommerce
     */
    protected function getWooCommerceService()
    {
        return $this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce');
    }

    /**
     * Gets the public 'MailPoet\Config\AccessControl' shared service.
     *
     * @return \MailPoet\Config\AccessControl
     */
    protected function getAccessControlService()
    {
        return $this->services['MailPoet\\Config\\AccessControl'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Config\\AccessControl');
    }

    /**
     * Gets the public 'MailPoet\Config\Renderer' shared service.
     *
     * @return \MailPoet\Config\Renderer
     */
    protected function getRendererService()
    {
        return $this->services['MailPoet\\Config\\Renderer'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Config\\Renderer');
    }

    /**
     * Gets the public 'MailPoet\Cron\Workers\StatsNotifications\NewsletterLinkRepository' shared service.
     *
     * @return \MailPoet\Cron\Workers\StatsNotifications\NewsletterLinkRepository
     */
    protected function getNewsletterLinkRepositoryService()
    {
        return $this->services['MailPoet\\Cron\\Workers\\StatsNotifications\\NewsletterLinkRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Cron\\Workers\\StatsNotifications\\NewsletterLinkRepository');
    }

    /**
     * Gets the public 'MailPoet\CustomFields\CustomFieldsRepository' shared service.
     *
     * @return \MailPoet\CustomFields\CustomFieldsRepository
     */
    protected function getCustomFieldsRepositoryService()
    {
        return $this->services['MailPoet\\CustomFields\\CustomFieldsRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\CustomFields\\CustomFieldsRepository');
    }

    /**
     * Gets the public 'MailPoet\Features\FeaturesController' shared service.
     *
     * @return \MailPoet\Features\FeaturesController
     */
    protected function getFeaturesControllerService()
    {
        return $this->services['MailPoet\\Features\\FeaturesController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Features\\FeaturesController');
    }

    /**
     * Gets the public 'MailPoet\Listing\Handler' shared service.
     *
     * @return \MailPoet\Listing\Handler
     */
    protected function getHandlerService()
    {
        return $this->services['MailPoet\\Listing\\Handler'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Listing\\Handler');
    }

    /**
     * Gets the public 'MailPoet\Listing\PageLimit' shared service.
     *
     * @return \MailPoet\Listing\PageLimit
     */
    protected function getPageLimitService()
    {
        return $this->services['MailPoet\\Listing\\PageLimit'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Listing\\PageLimit');
    }

    /**
     * Gets the public 'MailPoet\Mailer\MailerFactory' shared service.
     *
     * @return \MailPoet\Mailer\MailerFactory
     */
    protected function getMailerFactoryService()
    {
        return $this->services['MailPoet\\Mailer\\MailerFactory'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Mailer\\MailerFactory');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\NewsletterSaveController' shared service.
     *
     * @return \MailPoet\Newsletter\NewsletterSaveController
     */
    protected function getNewsletterSaveControllerService()
    {
        return $this->services['MailPoet\\Newsletter\\NewsletterSaveController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\NewsletterSaveController');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\NewslettersRepository' shared service.
     *
     * @return \MailPoet\Newsletter\NewslettersRepository
     */
    protected function getNewslettersRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\NewslettersRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\NewslettersRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Options\NewsletterOptionFieldsRepository' shared service.
     *
     * @return \MailPoet\Newsletter\Options\NewsletterOptionFieldsRepository
     */
    protected function getNewsletterOptionFieldsRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\Options\\NewsletterOptionFieldsRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Options\\NewsletterOptionFieldsRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Options\NewsletterOptionsRepository' shared service.
     *
     * @return \MailPoet\Newsletter\Options\NewsletterOptionsRepository
     */
    protected function getNewsletterOptionsRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\Options\\NewsletterOptionsRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Options\\NewsletterOptionsRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Sending\ScheduledTaskSubscribersRepository' shared service.
     *
     * @return \MailPoet\Newsletter\Sending\ScheduledTaskSubscribersRepository
     */
    protected function getScheduledTaskSubscribersRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\Sending\\ScheduledTaskSubscribersRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Sending\\ScheduledTaskSubscribersRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Sending\ScheduledTasksRepository' shared service.
     *
     * @return \MailPoet\Newsletter\Sending\ScheduledTasksRepository
     */
    protected function getScheduledTasksRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\Sending\\ScheduledTasksRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Sending\\ScheduledTasksRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Statistics\NewsletterStatisticsRepository' shared service.
     *
     * @return \MailPoet\Newsletter\Statistics\NewsletterStatisticsRepository
     */
    protected function getNewsletterStatisticsRepositoryService()
    {
        return $this->services['MailPoet\\Newsletter\\Statistics\\NewsletterStatisticsRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Statistics\\NewsletterStatisticsRepository');
    }

    /**
     * Gets the public 'MailPoet\Newsletter\Url' shared service.
     *
     * @return \MailPoet\Newsletter\Url
     */
    protected function getUrlService()
    {
        return $this->services['MailPoet\\Newsletter\\Url'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Newsletter\\Url');
    }

    /**
     * Gets the public 'MailPoet\Premium\API\JSON\v1\Bounces' shared autowired service.
     *
     * @return \MailPoet\Premium\API\JSON\v1\Bounces
     */
    protected function getBouncesService()
    {
        return $this->services['MailPoet\\Premium\\API\\JSON\\v1\\Bounces'] = new \MailPoet\Premium\API\JSON\v1\Bounces(($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService()), ($this->services['MailPoet\\Premium\\Newsletter\\Stats\\Bounces'] ?? $this->getBounces2Service()));
    }

    /**
     * Gets the public 'MailPoet\Premium\API\JSON\v1\ResponseBuilders\StatsResponseBuilder' shared autowired service.
     *
     * @return \MailPoet\Premium\API\JSON\v1\ResponseBuilders\StatsResponseBuilder
     */
    protected function getStatsResponseBuilderService()
    {
        return $this->services['MailPoet\\Premium\\API\\JSON\\v1\\ResponseBuilders\\StatsResponseBuilder'] = new \MailPoet\Premium\API\JSON\v1\ResponseBuilders\StatsResponseBuilder();
    }

    /**
     * Gets the public 'MailPoet\Premium\API\JSON\v1\Stats' shared autowired service.
     *
     * @return \MailPoet\Premium\API\JSON\v1\Stats
     */
    protected function getStatsService()
    {
        $a = ($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService());

        return $this->services['MailPoet\\Premium\\API\\JSON\\v1\\Stats'] = new \MailPoet\Premium\API\JSON\v1\Stats(new \MailPoet\Premium\Newsletter\Stats\PurchasedProducts(($this->services['MailPoet\\WooCommerce\\Helper'] ?? $this->getHelperService()), ($this->services['MailPoet\\Statistics\\StatisticsWooCommercePurchasesRepository'] ?? $this->getStatisticsWooCommercePurchasesRepositoryService()), $a, ($this->services['MailPoet\\WP\\Functions'] ?? $this->getFunctionsService())), $a, ($this->services['MailPoet\\Premium\\API\\JSON\\v1\\ResponseBuilders\\StatsResponseBuilder'] ?? ($this->services['MailPoet\\Premium\\API\\JSON\\v1\\ResponseBuilders\\StatsResponseBuilder'] = new \MailPoet\Premium\API\JSON\v1\ResponseBuilders\StatsResponseBuilder())), ($this->services['MailPoet\\Premium\\Newsletter\\StatisticsClicksRepository'] ?? $this->getStatisticsClicksRepositoryService()), ($this->services['MailPoet\\Premium\\Newsletter\\Stats\\SubscriberEngagement'] ?? $this->getSubscriberEngagementService()), ($this->services['MailPoet\\Newsletter\\Statistics\\NewsletterStatisticsRepository'] ?? $this->getNewsletterStatisticsRepositoryService()), ($this->services['MailPoet\\Newsletter\\Url'] ?? $this->getUrlService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\API\JSON\v1\SubscriberDetailedStats' shared autowired service.
     *
     * @return \MailPoet\Premium\API\JSON\v1\SubscriberDetailedStats
     */
    protected function getSubscriberDetailedStatsService()
    {
        return $this->services['MailPoet\\Premium\\API\\JSON\\v1\\SubscriberDetailedStats'] = new \MailPoet\Premium\API\JSON\v1\SubscriberDetailedStats(new \MailPoet\Premium\Subscriber\Stats\SubscriberNewsletterStatsRepository(($this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] ?? $this->getEntityManagerService())), new \MailPoet\Premium\API\JSON\v1\ResponseBuilders\SubscriberDetailedStatsResponseBuilder(($this->services['MailPoet\\Newsletter\\Url'] ?? $this->getUrlService()), ($this->services['MailPoet\\WooCommerce\\Helper'] ?? $this->getHelperService())), ($this->services['MailPoet\\Listing\\Handler'] ?? $this->getHandlerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Engine\Builder\CreateAutomationController' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Engine\Builder\CreateAutomationController
     */
    protected function getCreateAutomationControllerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Engine\\Builder\\CreateAutomationController'] = new \MailPoet\Premium\Automation\Engine\Builder\CreateAutomationController(($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Validation\\AutomationValidator'] ?? $this->getAutomationValidatorService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Engine\Builder\UpdateAutomationController' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Engine\Builder\UpdateAutomationController
     */
    protected function getUpdateAutomationController2Service()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Engine\\Builder\\UpdateAutomationController'] = new \MailPoet\Premium\Automation\Engine\Builder\UpdateAutomationController(($this->services['MailPoet\\Automation\\Engine\\Hooks'] ?? $this->getHooksService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStatisticsStorage'] ?? $this->getAutomationStatisticsStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Validation\\AutomationValidator'] ?? $this->getAutomationValidatorService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage'] ?? $this->getAutomationRunStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Control\\ActionScheduler'] ?? $this->getActionSchedulerService()), ($this->services['MailPoet\\Automation\\Engine\\Builder\\UpdateStepsController'] ?? $this->getUpdateStepsControllerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPostEndpoint' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPostEndpoint
     */
    protected function getAutomationsPostEndpointService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Engine\\Endpoints\\Automations\\AutomationsPostEndpoint'] = new \MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPostEndpoint(($this->services['MailPoet\\Premium\\Automation\\Engine\\Builder\\CreateAutomationController'] ?? $this->getCreateAutomationControllerService()), ($this->services['MailPoet\\Automation\\Engine\\Mappers\\AutomationMapper'] ?? $this->getAutomationMapperService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPutEndpoint' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPutEndpoint
     */
    protected function getAutomationsPutEndpointService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Engine\\Endpoints\\Automations\\AutomationsPutEndpoint'] = new \MailPoet\Premium\Automation\Engine\Endpoints\Automations\AutomationsPutEndpoint(($this->services['MailPoet\\Premium\\Automation\\Engine\\Builder\\UpdateAutomationController'] ?? $this->getUpdateAutomationController2Service()), ($this->services['MailPoet\\Automation\\Engine\\Mappers\\AutomationMapper'] ?? $this->getAutomationMapperService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Engine\Engine' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Engine\Engine
     */
    protected function getEngineService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Engine\\Engine'] = new \MailPoet\Premium\Automation\Engine\Engine(($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\MailPoetPremiumIntegration'] ?? $this->getMailPoetPremiumIntegrationService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WordPress\\WordPressIntegration'] ?? $this->getWordPressIntegrationService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\WooCommerceIntegration'] ?? $this->getWooCommerceIntegrationService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\WooCommerceSubscriptionsIntegration'] ?? $this->getWooCommerceSubscriptionsIntegrationService()), ($this->services['MailPoet\\WP\\Functions'] ?? $this->getFunctionsService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddTagAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddTagAction
     */
    protected function getAddTagActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddTagAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddTagAction(($this->services['MailPoet\\Subscribers\\SubscriberTagRepository'] ?? $this->getSubscriberTagRepositoryService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddToListAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddToListAction
     */
    protected function getAddToListActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddToListAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\AddToListAction(($this->services['MailPoet\\Segments\\SegmentsRepository'] ?? $this->getSegmentsRepositoryService()), ($this->services['MailPoet\\Subscribers\\SubscriberSegmentRepository'] ?? $this->getSubscriberSegmentRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\CustomAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\CustomAction
     */
    protected function getCustomActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\CustomAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\CustomAction();
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\NotificationEmailAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\NotificationEmailAction
     */
    protected function getNotificationEmailActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\NotificationEmailAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\NotificationEmailAction(($this->services['MailPoet\\Mailer\\MailerFactory'] ?? $this->getMailerFactoryService()), ($this->services['MailPoet\\Settings\\SettingsController'] ?? $this->getSettingsControllerService()), ($this->services['MailPoet\\Subscribers\\SubscribersRepository'] ?? $this->getSubscribersRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveFromListAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveFromListAction
     */
    protected function getRemoveFromListActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveFromListAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveFromListAction(($this->services['MailPoet\\Segments\\SegmentsRepository'] ?? $this->getSegmentsRepositoryService()), ($this->services['MailPoet\\Subscribers\\SubscriberSegmentRepository'] ?? $this->getSubscriberSegmentRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveTagAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveTagAction
     */
    protected function getRemoveTagActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveTagAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\RemoveTagAction(($this->services['MailPoet\\Subscribers\\SubscriberTagRepository'] ?? $this->getSubscriberTagRepositoryService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UnsubscribeAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UnsubscribeAction
     */
    protected function getUnsubscribeActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UnsubscribeAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UnsubscribeAction(($this->services['MailPoet\\Subscribers\\SubscribersRepository'] ?? $this->getSubscribersRepositoryService()), ($this->services['MailPoet\\Settings\\TrackingConfig'] ?? $this->getTrackingConfigService()), ($this->services['MailPoet\\Statistics\\Track\\Unsubscribes'] ?? $this->getUnsubscribesService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UpdateSubscriberAction' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UpdateSubscriberAction
     */
    protected function getUpdateSubscriberActionService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UpdateSubscriberAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\UpdateSubscriberAction(($this->services['MailPoet\\CustomFields\\CustomFieldsRepository'] ?? $this->getCustomFieldsRepositoryService()), ($this->services['MailPoet\\Subscribers\\SubscriberCustomFieldRepository'] ?? $this->getSubscriberCustomFieldRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Analytics' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Analytics
     */
    protected function getAnalyticsService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Analytics'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Analytics(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\OrderController' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\OrderController
     */
    protected function getOrderControllerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\OrderController'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\OrderController(($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\OrderStatistics'] ?? $this->getOrderStatisticsService()), ($this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] ?? $this->getWooCommerceService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Analytics\\Controller\\AutomationTimeSpanController'] ?? $this->getAutomationTimeSpanControllerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\RunLogController' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\RunLogController
     */
    protected function getRunLogControllerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\RunLogController'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\RunLogController(($this->services['MailPoet\\Automation\\Engine\\Control\\ActionScheduler'] ?? $this->getActionSchedulerService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunLogStorage'] ?? $this->getAutomationRunLogStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Registry'] ?? $this->getRegistryService()), ($this->services['MailPoet\\Subscribers\\SubscribersRepository'] ?? $this->getSubscribersRepositoryService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\SubscriberController' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\SubscriberController
     */
    protected function getSubscriberControllerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\SubscriberController'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Controller\SubscriberController(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\SubscriberStatistics'] ?? $this->getSubscriberStatisticsService()), ($this->services['MailPoet\\Automation\\Integrations\\MailPoet\\Analytics\\Controller\\AutomationTimeSpanController'] ?? $this->getAutomationTimeSpanControllerService()), ($this->services['MailPoet\\Automation\\Engine\\Registry'] ?? $this->getRegistryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\OrderEndpoint' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\OrderEndpoint
     */
    protected function getOrderEndpointService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\OrderEndpoint'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\OrderEndpoint(($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\OrderController'] ?? $this->getOrderControllerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\RunLogEndpoint' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\RunLogEndpoint
     */
    protected function getRunLogEndpointService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\RunLogEndpoint'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\RunLogEndpoint(($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage'] ?? $this->getAutomationRunStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\RunLogController'] ?? $this->getRunLogControllerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\SubscriberEndpoint' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\SubscriberEndpoint
     */
    protected function getSubscriberEndpointService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Endpoints\\SubscriberEndpoint'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Endpoints\SubscriberEndpoint(($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Controller\\SubscriberController'] ?? $this->getSubscriberControllerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\OrderStatistics' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\OrderStatistics
     */
    protected function getOrderStatisticsService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\OrderStatistics'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\OrderStatistics(($this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] ?? $this->getWooCommerceService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\SubscriberStatistics' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\SubscriberStatistics
     */
    protected function getSubscriberStatisticsService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Storage\\SubscriberStatistics'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Analytics\Storage\SubscriberStatistics(($this->services['MailPoet\\Automation\\Engine\\Registry'] ?? $this->getRegistryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\ContextFactory' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\ContextFactory
     */
    protected function getContextFactoryService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\ContextFactory'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\ContextFactory(($this->services['MailPoet\\CustomFields\\CustomFieldsRepository'] ?? $this->getCustomFieldsRepositoryService()), ($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\MailPoetPremiumIntegration' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\MailPoetPremiumIntegration
     */
    protected function getMailPoetPremiumIntegrationService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\MailPoetPremiumIntegration'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\MailPoetPremiumIntegration(($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\ContextFactory'] ?? $this->getContextFactoryService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UnsubscribeAction'] ?? $this->getUnsubscribeActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddTagAction'] ?? $this->getAddTagActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveTagAction'] ?? $this->getRemoveTagActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\AddToListAction'] ?? $this->getAddToListActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\RemoveFromListAction'] ?? $this->getRemoveFromListActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\UpdateSubscriberAction'] ?? $this->getUpdateSubscriberActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\NotificationEmailAction'] ?? $this->getNotificationEmailActionService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\CustomTrigger'] ?? $this->getCustomTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\ClicksEmailLinkTrigger'] ?? $this->getClicksEmailLinkTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\CustomDataSubject'] ?? ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\CustomDataSubject'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\CustomDataSubject())), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\CustomAction'] ?? ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Actions\\CustomAction'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Actions\CustomAction())), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagAddedTrigger'] ?? $this->getTagAddedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagRemovedTrigger'] ?? $this->getTagRemovedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\TagSubject'] ?? $this->getTagSubjectService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\UserRoleChangeSubject'] ?? ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\UserRoleChangeSubject'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\UserRoleChangeSubject())), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\UserRoleChangedTrigger'] ?? $this->getUserRoleChangedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumTemplatesFactory'] ?? $this->getPremiumTemplatesFactoryService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Analytics\\Analytics'] ?? $this->getAnalyticsService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\CustomDataSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\CustomDataSubject
     */
    protected function getCustomDataSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\CustomDataSubject'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\CustomDataSubject();
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\TagSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\TagSubject
     */
    protected function getTagSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\TagSubject'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\TagSubject(($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\UserRoleChangeSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\UserRoleChangeSubject
     */
    protected function getUserRoleChangeSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Subjects\\UserRoleChangeSubject'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Subjects\UserRoleChangeSubject();
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumEmailFactory' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumEmailFactory
     */
    protected function getPremiumEmailFactoryService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumEmailFactory'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumEmailFactory(($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService()), ($this->services['MailPoet\\Settings\\SettingsController'] ?? $this->getSettingsControllerService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Newsletter\\Options\\NewsletterOptionsRepository'] ?? $this->getNewsletterOptionsRepositoryService()), ($this->services['MailPoet\\Newsletter\\Options\\NewsletterOptionFieldsRepository'] ?? $this->getNewsletterOptionFieldsRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumTemplatesFactory' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumTemplatesFactory
     */
    protected function getPremiumTemplatesFactoryService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumTemplatesFactory'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Templates\PremiumTemplatesFactory(($this->services['MailPoet\\Automation\\Engine\\Templates\\AutomationBuilder'] ?? $this->getAutomationBuilderService()), ($this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] ?? $this->getWooCommerceService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Templates\\PremiumEmailFactory'] ?? $this->getPremiumEmailFactoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\ClicksEmailLinkTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\ClicksEmailLinkTrigger
     */
    protected function getClicksEmailLinkTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\ClicksEmailLinkTrigger'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\ClicksEmailLinkTrigger(($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService()), ($this->services['MailPoet\\Cron\\Workers\\StatsNotifications\\NewsletterLinkRepository'] ?? $this->getNewsletterLinkRepositoryService()), ($this->services['MailPoet\\Premium\\Newsletter\\StatisticsClicksRepository'] ?? $this->getStatisticsClicksRepositoryService()), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\CustomTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\CustomTrigger
     */
    protected function getCustomTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\CustomTrigger'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\CustomTrigger(($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationStorage'] ?? $this->getAutomationStorageService()), ($this->services['MailPoet\\Subscribers\\SubscribersRepository'] ?? $this->getSubscribersRepositoryService()), ($this->services['MailPoet\\WP\\Functions'] ?? $this->getFunctionsService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagAddedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagAddedTrigger
     */
    protected function getTagAddedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagAddedTrigger'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagAddedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagRemovedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagRemovedTrigger
     */
    protected function getTagRemovedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\TagRemovedTrigger'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\TagRemovedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\UserRoleChangedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\UserRoleChangedTrigger
     */
    protected function getUserRoleChangedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\MailPoetPremium\\Triggers\\UserRoleChangedTrigger'] = new \MailPoet\Premium\Automation\Integrations\MailPoetPremium\Triggers\UserRoleChangedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Subscribers\\SubscribersRepository'] ?? $this->getSubscribersRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\ContextFactory' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\ContextFactory
     */
    protected function getContextFactory2Service()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\ContextFactory'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\ContextFactory(($this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] ?? $this->getHelper2Service()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Fields\SubscriptionFields' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Fields\SubscriptionFields
     */
    protected function getSubscriptionFieldsService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Fields\\SubscriptionFields'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Fields\SubscriptionFields(($this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] ?? $this->getHelper2Service()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionStatusChangeSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionStatusChangeSubject
     */
    protected function getWooCommerceSubscriptionStatusChangeSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionStatusChangeSubject'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionStatusChangeSubject();
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionSubject
     */
    protected function getWooCommerceSubscriptionSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionSubject'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionSubject(($this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] ?? $this->getHelper2Service()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Fields\\SubscriptionFields'] ?? $this->getSubscriptionFieldsService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionCreatedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionCreatedTrigger
     */
    protected function getSubscriptionCreatedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionCreatedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionCreatedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] ?? $this->getHelper2Service()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionExpiredTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionExpiredTrigger
     */
    protected function getSubscriptionExpiredTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionExpiredTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionExpiredTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionPaymentFailedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionPaymentFailedTrigger
     */
    protected function getSubscriptionPaymentFailedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionPaymentFailedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionPaymentFailedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionRenewedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionRenewedTrigger
     */
    protected function getSubscriptionRenewedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionRenewedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionRenewedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionStatusChangedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionStatusChangedTrigger
     */
    protected function getSubscriptionStatusChangedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionStatusChangedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionStatusChangedTrigger(($this->services['MailPoet\\WP\\Functions'] ?? $this->getFunctionsService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialEndedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialEndedTrigger
     */
    protected function getSubscriptionTrialEndedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialEndedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialEndedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] ?? $this->getHelper2Service()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialStartedTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialStartedTrigger
     */
    protected function getSubscriptionTrialStartedTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialStartedTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Triggers\SubscriptionTrialStartedTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\WooCommerceSubscriptionsIntegration' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\WooCommerceSubscriptionsIntegration
     */
    protected function getWooCommerceSubscriptionsIntegrationService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\WooCommerceSubscriptionsIntegration'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\WooCommerceSubscriptionsIntegration(($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\ContextFactory'] ?? $this->getContextFactory2Service()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionCreatedTrigger'] ?? $this->getSubscriptionCreatedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionStatusChangedTrigger'] ?? $this->getSubscriptionStatusChangedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialEndedTrigger'] ?? $this->getSubscriptionTrialEndedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionTrialStartedTrigger'] ?? $this->getSubscriptionTrialStartedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionRenewedTrigger'] ?? $this->getSubscriptionRenewedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionPaymentFailedTrigger'] ?? $this->getSubscriptionPaymentFailedTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Triggers\\SubscriptionExpiredTrigger'] ?? $this->getSubscriptionExpiredTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionSubject'] ?? $this->getWooCommerceSubscriptionSubjectService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionStatusChangeSubject'] ?? ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerceSubscriptions\\Subjects\\WooCommerceSubscriptionStatusChangeSubject'] = new \MailPoet\Premium\Automation\Integrations\WooCommerceSubscriptions\Subjects\WooCommerceSubscriptionStatusChangeSubject())));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerce\Actions\Extenders\ReviewCrossSellHandler' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerce\Actions\Extenders\ReviewCrossSellHandler
     */
    protected function getReviewCrossSellHandlerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Actions\\Extenders\\ReviewCrossSellHandler'] = new \MailPoet\Premium\Automation\Integrations\WooCommerce\Actions\Extenders\ReviewCrossSellHandler();
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerce\Subjects\ReviewSubject' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerce\Subjects\ReviewSubject
     */
    protected function getReviewSubjectService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Subjects\\ReviewSubject'] = new \MailPoet\Premium\Automation\Integrations\WooCommerce\Subjects\ReviewSubject(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] ?? $this->getWooCommerceService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerce\Triggers\MadeAReviewTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerce\Triggers\MadeAReviewTrigger
     */
    protected function getMadeAReviewTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Triggers\\MadeAReviewTrigger'] = new \MailPoet\Premium\Automation\Integrations\WooCommerce\Triggers\MadeAReviewTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage'] ?? $this->getAutomationRunStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Control\\FilterHandler'] ?? $this->getFilterHandlerService()), ($this->services['MailPoet\\Automation\\Integrations\\WooCommerce\\WooCommerce'] ?? $this->getWooCommerceService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WooCommerce\WooCommerceIntegration' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WooCommerce\WooCommerceIntegration
     */
    protected function getWooCommerceIntegrationService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\WooCommerceIntegration'] = new \MailPoet\Premium\Automation\Integrations\WooCommerce\WooCommerceIntegration(($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Triggers\\MadeAReviewTrigger'] ?? $this->getMadeAReviewTriggerService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Subjects\\ReviewSubject'] ?? $this->getReviewSubjectService()), ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Actions\\Extenders\\ReviewCrossSellHandler'] ?? ($this->services['MailPoet\\Premium\\Automation\\Integrations\\WooCommerce\\Actions\\Extenders\\ReviewCrossSellHandler'] = new \MailPoet\Premium\Automation\Integrations\WooCommerce\Actions\Extenders\ReviewCrossSellHandler())), ($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WordPress\Triggers\MadeACommentTrigger' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WordPress\Triggers\MadeACommentTrigger
     */
    protected function getMadeACommentTriggerService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WordPress\\Triggers\\MadeACommentTrigger'] = new \MailPoet\Premium\Automation\Integrations\WordPress\Triggers\MadeACommentTrigger(($this->services['MailPoet\\Automation\\Engine\\WordPress'] ?? $this->getWordPressService()), ($this->services['MailPoet\\Automation\\Engine\\Storage\\AutomationRunStorage'] ?? $this->getAutomationRunStorageService()), ($this->services['MailPoet\\Automation\\Engine\\Control\\FilterHandler'] ?? $this->getFilterHandlerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Automation\Integrations\WordPress\WordPressIntegration' shared autowired service.
     *
     * @return \MailPoet\Premium\Automation\Integrations\WordPress\WordPressIntegration
     */
    protected function getWordPressIntegrationService()
    {
        return $this->services['MailPoet\\Premium\\Automation\\Integrations\\WordPress\\WordPressIntegration'] = new \MailPoet\Premium\Automation\Integrations\WordPress\WordPressIntegration(($this->services['MailPoet\\Premium\\Automation\\Integrations\\WordPress\\Triggers\\MadeACommentTrigger'] ?? $this->getMadeACommentTriggerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Config\Initializer' shared autowired service.
     *
     * @return \MailPoet\Premium\Config\Initializer
     */
    protected function getInitializerService()
    {
        $a = ($this->services['MailPoet\\WP\\Functions'] ?? $this->getFunctionsService());

        return $this->services['MailPoet\\Premium\\Config\\Initializer'] = new \MailPoet\Premium\Config\Initializer($a, new \MailPoet\Premium\Config\Hooks($a), ($this->services['MailPoet\\Premium\\Segments\\DynamicSegments\\SegmentCombinations'] ?? ($this->services['MailPoet\\Premium\\Segments\\DynamicSegments\\SegmentCombinations'] = new \MailPoet\Premium\Segments\DynamicSegments\SegmentCombinations())), ($this->services['MailPoet\\Premium\\Segments\\DynamicSegments\\Filters\\SubscriberTag'] ?? $this->getSubscriberTagService()), ($this->services['MailPoet\\Premium\\Automation\\Engine\\Engine'] ?? $this->getEngineService()), ($this->services['MailPoet\\Premium\\Config\\RendererFactory'] ?? ($this->services['MailPoet\\Premium\\Config\\RendererFactory'] = new \MailPoet\Premium\Config\RendererFactory())), ($this->services['MailPoet\\Util\\License\\Features\\Subscribers'] ?? $this->getSubscribersService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Config\Renderer' shared service.
     *
     * @return \MailPoet\Premium\Config\Renderer
     */
    protected function getRenderer2Service()
    {
        return $this->services['MailPoet\\Premium\\Config\\Renderer'] = ($this->services['MailPoet\\Premium\\Config\\RendererFactory'] ?? ($this->services['MailPoet\\Premium\\Config\\RendererFactory'] = new \MailPoet\Premium\Config\RendererFactory()))->getRenderer();
    }

    /**
     * Gets the public 'MailPoet\Premium\Config\RendererFactory' shared autowired service.
     *
     * @return \MailPoet\Premium\Config\RendererFactory
     */
    protected function getRendererFactoryService()
    {
        return $this->services['MailPoet\\Premium\\Config\\RendererFactory'] = new \MailPoet\Premium\Config\RendererFactory();
    }

    /**
     * Gets the public 'MailPoet\Premium\Newsletter\StatisticsClicksRepository' shared autowired service.
     *
     * @return \MailPoet\Premium\Newsletter\StatisticsClicksRepository
     */
    protected function getStatisticsClicksRepositoryService()
    {
        return $this->services['MailPoet\\Premium\\Newsletter\\StatisticsClicksRepository'] = new \MailPoet\Premium\Newsletter\StatisticsClicksRepository(($this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] ?? $this->getEntityManagerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Newsletter\Stats\Bounces' shared autowired service.
     *
     * @return \MailPoet\Premium\Newsletter\Stats\Bounces
     */
    protected function getBounces2Service()
    {
        return $this->services['MailPoet\\Premium\\Newsletter\\Stats\\Bounces'] = new \MailPoet\Premium\Newsletter\Stats\Bounces(($this->services['MailPoet\\Listing\\Handler'] ?? $this->getHandlerService()), ($this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] ?? $this->getEntityManagerService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Newsletter\Stats\SubscriberEngagement' shared autowired service.
     *
     * @return \MailPoet\Premium\Newsletter\Stats\SubscriberEngagement
     */
    protected function getSubscriberEngagementService()
    {
        return $this->services['MailPoet\\Premium\\Newsletter\\Stats\\SubscriberEngagement'] = new \MailPoet\Premium\Newsletter\Stats\SubscriberEngagement(($this->services['MailPoet\\Listing\\Handler'] ?? $this->getHandlerService()), ($this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] ?? $this->getEntityManagerService()), ($this->services['MailPoet\\Premium\\Newsletter\\StatisticsClicksRepository'] ?? $this->getStatisticsClicksRepositoryService()), ($this->services['MailPoet\\Cron\\Workers\\StatsNotifications\\NewsletterLinkRepository'] ?? $this->getNewsletterLinkRepositoryService()), ($this->services['MailPoet\\Newsletter\\NewslettersRepository'] ?? $this->getNewslettersRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Segments\DynamicSegments\Filters\SubscriberTag' shared autowired service.
     *
     * @return \MailPoet\Premium\Segments\DynamicSegments\Filters\SubscriberTag
     */
    protected function getSubscriberTagService()
    {
        return $this->services['MailPoet\\Premium\\Segments\\DynamicSegments\\Filters\\SubscriberTag'] = new \MailPoet\Premium\Segments\DynamicSegments\Filters\SubscriberTag(($this->services['MailPoetVendor\\Doctrine\\ORM\\EntityManager'] ?? $this->getEntityManagerService()), ($this->services['MailPoet\\Tags\\TagRepository'] ?? $this->getTagRepositoryService()));
    }

    /**
     * Gets the public 'MailPoet\Premium\Segments\DynamicSegments\SegmentCombinations' shared autowired service.
     *
     * @return \MailPoet\Premium\Segments\DynamicSegments\SegmentCombinations
     */
    protected function getSegmentCombinationsService()
    {
        return $this->services['MailPoet\\Premium\\Segments\\DynamicSegments\\SegmentCombinations'] = new \MailPoet\Premium\Segments\DynamicSegments\SegmentCombinations();
    }

    /**
     * Gets the public 'MailPoet\Segments\SegmentsRepository' shared service.
     *
     * @return \MailPoet\Segments\SegmentsRepository
     */
    protected function getSegmentsRepositoryService()
    {
        return $this->services['MailPoet\\Segments\\SegmentsRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Segments\\SegmentsRepository');
    }

    /**
     * Gets the public 'MailPoet\Settings\SettingsController' shared service.
     *
     * @return \MailPoet\Settings\SettingsController
     */
    protected function getSettingsControllerService()
    {
        return $this->services['MailPoet\\Settings\\SettingsController'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Settings\\SettingsController');
    }

    /**
     * Gets the public 'MailPoet\Settings\TrackingConfig' shared service.
     *
     * @return \MailPoet\Settings\TrackingConfig
     */
    protected function getTrackingConfigService()
    {
        return $this->services['MailPoet\\Settings\\TrackingConfig'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Settings\\TrackingConfig');
    }

    /**
     * Gets the public 'MailPoet\Statistics\StatisticsWooCommercePurchasesRepository' shared service.
     *
     * @return \MailPoet\Statistics\StatisticsWooCommercePurchasesRepository
     */
    protected function getStatisticsWooCommercePurchasesRepositoryService()
    {
        return $this->services['MailPoet\\Statistics\\StatisticsWooCommercePurchasesRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Statistics\\StatisticsWooCommercePurchasesRepository');
    }

    /**
     * Gets the public 'MailPoet\Statistics\Track\Unsubscribes' shared service.
     *
     * @return \MailPoet\Statistics\Track\Unsubscribes
     */
    protected function getUnsubscribesService()
    {
        return $this->services['MailPoet\\Statistics\\Track\\Unsubscribes'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Statistics\\Track\\Unsubscribes');
    }

    /**
     * Gets the public 'MailPoet\Subscribers\SubscriberCustomFieldRepository' shared service.
     *
     * @return \MailPoet\Subscribers\SubscriberCustomFieldRepository
     */
    protected function getSubscriberCustomFieldRepositoryService()
    {
        return $this->services['MailPoet\\Subscribers\\SubscriberCustomFieldRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Subscribers\\SubscriberCustomFieldRepository');
    }

    /**
     * Gets the public 'MailPoet\Subscribers\SubscriberSegmentRepository' shared service.
     *
     * @return \MailPoet\Subscribers\SubscriberSegmentRepository
     */
    protected function getSubscriberSegmentRepositoryService()
    {
        return $this->services['MailPoet\\Subscribers\\SubscriberSegmentRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Subscribers\\SubscriberSegmentRepository');
    }

    /**
     * Gets the public 'MailPoet\Subscribers\SubscriberTagRepository' shared service.
     *
     * @return \MailPoet\Subscribers\SubscriberTagRepository
     */
    protected function getSubscriberTagRepositoryService()
    {
        return $this->services['MailPoet\\Subscribers\\SubscriberTagRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Subscribers\\SubscriberTagRepository');
    }

    /**
     * Gets the public 'MailPoet\Subscribers\SubscribersRepository' shared service.
     *
     * @return \MailPoet\Subscribers\SubscribersRepository
     */
    protected function getSubscribersRepositoryService()
    {
        return $this->services['MailPoet\\Subscribers\\SubscribersRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Subscribers\\SubscribersRepository');
    }

    /**
     * Gets the public 'MailPoet\Tags\TagRepository' shared service.
     *
     * @return \MailPoet\Tags\TagRepository
     */
    protected function getTagRepositoryService()
    {
        return $this->services['MailPoet\\Tags\\TagRepository'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Tags\\TagRepository');
    }

    /**
     * Gets the public 'MailPoet\Util\CdnAssetUrl' shared service.
     *
     * @return \MailPoet\Util\CdnAssetUrl
     */
    protected function getCdnAssetUrlService()
    {
        return $this->services['MailPoet\\Util\\CdnAssetUrl'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Util\\CdnAssetUrl');
    }

    /**
     * Gets the public 'MailPoet\Util\License\Features\Subscribers' shared service.
     *
     * @return \MailPoet\Util\License\Features\Subscribers
     */
    protected function getSubscribersService()
    {
        return $this->services['MailPoet\\Util\\License\\Features\\Subscribers'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\Util\\License\\Features\\Subscribers');
    }

    /**
     * Gets the public 'MailPoet\WP\Functions' shared service.
     *
     * @return \MailPoet\WP\Functions
     */
    protected function getFunctionsService()
    {
        return $this->services['MailPoet\\WP\\Functions'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\WP\\Functions');
    }

    /**
     * Gets the public 'MailPoet\WooCommerce\Helper' shared service.
     *
     * @return \MailPoet\WooCommerce\Helper
     */
    protected function getHelperService()
    {
        return $this->services['MailPoet\\WooCommerce\\Helper'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\WooCommerce\\Helper');
    }

    /**
     * Gets the public 'MailPoet\WooCommerce\WooCommerceSubscriptions\Helper' shared service.
     *
     * @return \MailPoet\WooCommerce\WooCommerceSubscriptions\Helper
     */
    protected function getHelper2Service()
    {
        return $this->services['MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper'] = ($this->services['free_container'] ?? $this->get('free_container', 1))->get('MailPoet\\WooCommerce\\WooCommerceSubscriptions\\Helper');
    }
}
